'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

    'Deklaration der erforderlichen Typen, Konstanten und Funktionen
    
    Type DateiDialogStruktur
            lStructSize As Long
            hwndOwner As Long
            hInstance As Long
            lpstrFilter As String
            lpstrCustomFilter As String
            nMaxCustFilter As Long
            nFilterIndex As Long
            lpstrFile As String
            nMaxFile As Long
            lpstrFileTitle As String
            nMaxFileTitle As Long
            lpstrInitialDir As String
            lpstrTitle As String
            Flags As Long
            nFileOffset As Integer
            nFileExtension As Integer
            lpstrDefExt As String
            lCustData As Long
            lpfnHook As Long
            lpTemplateName As String
    End Type
     
    Declare Function GetOpenFileName Lib "comdlg32.dll" Alias "GetOpenFileNameA" _
    (DateiDialogStruktur As DateiDialogStruktur) As Long
     
    Const OFN_ALLOWMULTISELECT = &H200
    Const OFN_CREATEPROMPT = &H2000
    Const OFN_ENABLEHOOK = &H20
    Const OFN_ENABLETEMPLATE = &H40
    Const OFN_ENABLETEMPLATEHANDLE = &H80
    Const OFN_EXPLORER = &H80000
    Const OFN_EXTENSIONDIFFERENT = &H400
    Const OFN_FILEMUSTEXIST = &H1000
    Const OFN_HIDEREADONLY = &H4
    Const OFN_LONGNAMES = &H200000
    Const OFN_NOCHANGEDIR = &H8
    Const OFN_NODEREFERENCELINKS = &H100000
    Const OFN_NOLONGNAMES = &H40000
    Const OFN_NONETWORKBUTTON = &H20000
    Const OFN_NOREADONLYRETURN = &H8000
    Const OFN_NOTESTFILECREATE = &H10000
    Const OFN_NOVALIDATE = &H100
    Const OFN_OVERWRITEPROMPT = &H2
    Const OFN_PATHMUSTEXIST = &H800
    Const OFN_READONLY = &H1
    Const OFN_SHAREAWARE = &H4000
    Const OFN_SHAREFALLTHROUGH = 2
    Const OFN_SHARENOWARN = 1
    Const OFN_SHAREWARN = 0
    Const OFN_SHOWHELP = &H10
     
    Dim DateiDialogStruktur As DateiDialogStruktur
    
    Function DateiOeffnen(Verzeichnis As String, Fenstertitel As String) As String
        On Error GoTo Err_DateiOeffnen
         
            Dim Dateityp As String
            Dim Dateiname_mit_Pfad As String
            Dim Dateiname As String
            Dim Rueckwerte As Long
         
            Dateityp = ""
         
        ' Dateitypen in der Auswahlliste des Dateityp's
        ' Access-Dateitypen
        
            'Wenn Access 2007 (oder hher) luft                        'acSysCmdAccessVer = 7 (ParameterNummer)
            If Fix(Val(SysCmd(acSysCmdAccessVer))) >= 12 Then           '12 = Access 2007
                Dateityp = Dateityp & _
                "Access 2007 (*.accdb)" & Chr$(0) & "*.accdb" & Chr$(0)
            End If
        
            Dateityp = Dateityp & _
            "Access 2000-2003 (*.mdb)" & Chr$(0) & "*.mdb" & Chr$(0)
         
          '  Dateityp = Dateityp & _
          '  "Add-Ins (*.mda)" & Chr$(0) & "*.mda" & Chr$(0)
          '
          '  Dateityp = Dateityp & _
          '  "Arbeitsgruppen-Dateien (*.mdw)" & Chr$(0) & "*.mdw" & Chr$(0)
          '
          '  Dateityp = Dateityp & _
          '  "MDE-Dateien (*.mde)" & Chr$(0) & "*.mde" & Chr$(0)
          
        '   Excel-Dateien fr Matrix Kalender/Kategorien
        If Fenstertitel = "Excel-Matrix Kalender/Kategorien ffnen" Then
            Dateityp = "Termin-Dateien (*Termine*.xls*)" & Chr$(0) & "*Termine*.xls*" & Chr$(0)
            Dateityp = Dateityp & "Excel-Dateien (*.xls*)" & Chr$(0) & "*.xls*" & Chr$(0)
        End If
        
        '   Text-Datei fr Kategorie-Vorgabeliste
        If Fenstertitel = "Datei mit Kategorienliste ffnen" Then
            Dateityp = "Text-Dateien (*.txt*)" & Chr$(0) & "*.txt*" & Chr$(0)
        End If
         
        '   Alle Dateien
            Dateityp = Dateityp & "Alle Dateien (*.*)" & Chr$(0) & "*.*" & Chr$(0)
         
        ' Word-Dateitypen
        '   Word-Dokumente (*.doc)
        '   Dokumentenvorlagen (*.dot)
        '   Rich Text Format (*.rtf)
        '   Textdateien (*.txt)
        '   Schedule+-Kontakte (*.scd)
        '   Persnliches Adrebuch (*.pab)
        '   Outlook-Adrebuch (*.olk)
        '   MS-DOS Text mit Layout (*.asc)
        '   Text mit Layout (*.ans)
        '   HTML Document (*.htm;*.html;*.htx)
        '   Windows Write (*.wri)
        '   Lotus 1-2-3 (*.wk1;*.wk3;*.wk4)
        '   WordPerfect 6.x (*.wpd;*.doc)
        '   Microsoft Excel-Arbeitsmappen (*.xls)
        '   Works 3.0 fr Windows (*.wps)
        '   Works 4.0 fr Windows (*.wps)
         
        ' Excel-Dateitypen
        '   Textdateien (*.prn;*.txt;*.csv)
        '   QuattroPro/DOS-Dateien (*.wq1)
        '   Microsoft Works 2.0-Dateien (*.wks)
        '   dBASE-Dateien (*.dbf)
        '   Add-Ins (*.xla;*.xll)
        '   Mustervorlagen (*.xlt)
        '   Arbeitsbereiche (*.xlw)
        '   Tabellen (*.xls)
         
        '   Sicherungsdateien (*.xlk;*.bak)
        '   HTML-Dateien (*.html;*.htm)
         
         
        ' Vorgegebenes Verzeichnis
            If Verzeichnis = "" Then
                ' Wenn leer, dann soll das aktuelle Verzeichnis verwendet werden
                Verzeichnis = CurDir$ & Chr$(0)
            Else
                ' ANSI "0" an das bergebene Verzeichnis anhngen
                Verzeichnis = Verzeichnis & Chr$(0)
            End If
         
            If Fenstertitel = "" Then
                ' Wenn kein Titel bergeben worden ist
                Fenstertitel = "Datei ffnen"
            Else
                ' ANSI "0" an bergebenen Fenstertitel anhngen
                Fenstertitel = Fenstertitel & Chr$(0)
            End If
         
        ' Speicherplatz fr Dateieintrag (mit Pfadangabe) reservieren
            Dateiname_mit_Pfad = Space$(255) & Chr$(0)
         
        ' Speicherplatz fr Dateieintrag (ohne Pfadangabe) reservieren
            Dateiname = Space$(255) & Chr$(0)
         
        'Datenstruktur von DateiDialogStruktur festlegen
            DateiDialogStruktur.lStructSize = Len(DateiDialogStruktur)
            DateiDialogStruktur.hwndOwner = 0&
            'DateiDialogStruktur.hwndOwner = Application.hWndAccessApp
            DateiDialogStruktur.lpstrFilter = Dateityp
            DateiDialogStruktur.nFilterIndex = 1
            DateiDialogStruktur.lpstrFile = Dateiname_mit_Pfad
            DateiDialogStruktur.nMaxFile = Len(Dateiname_mit_Pfad)
            DateiDialogStruktur.lpstrFileTitle = Dateiname
            DateiDialogStruktur.nMaxFileTitle = Len(Dateiname)
            DateiDialogStruktur.lpstrInitialDir = Verzeichnis
            DateiDialogStruktur.lpstrTitle = Fenstertitel
            DateiDialogStruktur.Flags = OFN_FILEMUSTEXIST Or OFN_PATHMUSTEXIST _
            Or OFN_HIDEREADONLY Or OFN_LONGNAMES
            DateiDialogStruktur.nFileOffset = 0
            DateiDialogStruktur.nFileExtension = 0
            DateiDialogStruktur.lCustData = 0
            DateiDialogStruktur.lpfnHook = 0
            DateiDialogStruktur.lpTemplateName = ""
         
            Rueckwerte = GetOpenFileName(DateiDialogStruktur)
         
            If Rueckwerte <> 0 Then
                DateiOeffnen = Left(DateiDialogStruktur.lpstrFile, InStr(DateiDialogStruktur.lpstrFile, Chr$(0)) - 1)
            End If
         
Exit_DateiOeffnen:
            Exit Function
         
Err_DateiOeffnen:
            MsgBox err.Description
            Resume Exit_DateiOeffnen
         
        End Function

